;;
;;;
;;;    TEXTFIT.LSP
;;;    Copyright  1999 by Autodesk, Inc.
;;;
;;;    Your use of this software is governed by the terms and conditions of the
;;;    License Agreement you accepted prior to installation of this software.
;;;    Please note that pursuant to the License Agreement for this software,
;;;    "[c]opying of this computer program or its documentation except as
;;;    permitted by this License is copyright infringement under the laws of
;;;    your country.  If you copy this computer program without permission of
;;;    Autodesk, you are violating the law."
;;;
;;;    AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
;;;    AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
;;;    MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
;;;    DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
;;;    UNINTERRUPTED OR ERROR FREE.
;;;
;;;    Use, duplication, or disclosure by the U.S. Government is subject to
;;;    restrictions set forth in FAR 52.227-19 (Commercial Computer
;;;    Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
;;;    (Rights in Technical Data and Computer Software), as applicable.
;;;
;;;  ----------------------------------------------------------------
 
 
(defun c:textfit (/ ename textent newend tmp start newpt val ltc_% ss txtsz)
 
  (acet-error-init
    (list
        (list  "cmdecho"    0
               "snapang"    0
              "limcheck"    0
              "orthomode"  1
        )
        T     ;flag. True means use undo for error clean up.
     ) ;list
  );acet-error-init
 
;;;End Error control
 
  (if (not (and
              (setq ss (ssget "_i"))
              (= (sslength ss) 1)
              (setq ename (ssname ss 0)
              )
           )
      )
    (setq ename  (car (entsel "\nSelect Text to stretch or shrink:" )))
  )
 
 
  (cond
    ((not (setq textent (if ename (entget ename))))
      (princ "\nNo object selected!")
    )
    ((/= (acet-dxf 0 textent) "TEXT")
      (princ "\nSelected object is not Text!")
    )
    ((acet-layer-locked (acet-dxf 8 textent))
      (princ "\nSelected object is on a locked layer!")
    )
    (t
      (setq txtsz (textbox textent))
      (setq newend (distance
                      (list
                        (caadr txtsz) ;upper right x coord
                        (cadar txtsz) ;lower left y coord
                      )
                      (car txtsz) ;; ll xyz
                   );distance
      );setq
      ;set snap along text entity
      (setvar "snapang"
        (angtof (angtos (acet-dxf 50 textent) 0 8) 0 )
      )
      (initget 0 "Start _Start")
      (setq
        tmp (getpoint (acet-dxf 10 textent) "\nSpecify end point or [Start point]: ")
      )
      (setvar "snapang" 0)
      (cond
        ((= (type tmp) 'STR) ;;new starting point to be selected
          (setq start (getpoint "\nSpecify new starting point: "))
          (if start
            (progn
              (acet-ucs-cmd (list "_E" (acet-dxf -1 textent)))
              (setvar "orthomode" 1)
              (setq newpt
                (if start
                  (getpoint (trans start 0 1) " ending point: ")
                  nil
                ) ;if
              ) ;setq
              (if newpt
                (setq newpt (trans newpt 1 0))
              )
              (setvar "orthomode" 0)
              (acet-ucs-cmd (list "_p"))
            ) ;progn
          ) if
        )
        ((not (null tmp))    ;;new ending point selected
          (setq start (acet-dxf 10 textent)
                newpt tmp)
        )
        (t  (setq start nil
                  newpt nil)
        )
      ) ;cond
      (if (and start newpt)
        (progn
          (setq val (assoc 41 textent) ;;current width factor
                val (if val (cdr val) 1.0)
                ltc_% (* (/ (distance start newpt) newend) val)
                textent (subst (cons 41 ltc_%)
                               (assoc 41 textent)
                               textent)
                textent (subst (cons 10 start)
                               (assoc 10 textent)
                               textent)
                textent (subst (cons 11 newpt)
                               (assoc 11 textent)
                               textent)
          ) ;setq
          (entmod textent)
          (entupd (acet-dxf -1 textent))
        )
      )  ;;end of points check
    )
  ) ;cond
  (acet-error-restore)
  (princ)
) ;end defun
 
 
 
 
(defun c:TFHELP (/)
 
(prompt " TEXTFIT will change the width factor of the selected text, \n")
(prompt " to fit within the user specified points.\n")
(prompt "\n")
(prompt " TEXTFIT will prompt:  Select Text to stretch/shrink:\n")
(prompt " The user is expected to select the text.\n")
(prompt "\n")
(prompt " TEXTFIT will then prompt:  Specify starting Point/<select new ending point>: \n")
(prompt " At which time the user can specify a new ending point \n")
(prompt "                          or\n")
(prompt " The user can provide the letter \"S\" for a new starting point\n")
(prompt " to which TEXTFIT will prompt:  Specify new starting point:  \n")
(prompt " and:  ending point: \n")
(textscr)
(princ)
)


(princ)

;;;-----BEGIN-SIGNATURE-----
;;; aAcAADCCB2QGCSqGSIb3DQEHAqCCB1UwggdRAgEBMQ8wDQYJKoZIhvcNAQELBQAw
;;; CwYJKoZIhvcNAQcBoIIFBjCCBQIwggPqoAMCAQICEGS8scfO5NpYadWPHiL76fQw
;;; DQYJKoZIhvcNAQELBQAwfzELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5bWFudGVj
;;; IENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3b3JrMTAw
;;; LgYDVQQDEydTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBDb2RlIFNpZ25pbmcgQ0Ew
;;; HhcNMTUwOTAzMDAwMDAwWhcNMTYwOTAyMjM1OTU5WjCBiDELMAkGA1UEBhMCVVMx
;;; EzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwxFjAUBgNV
;;; BAoMDUF1dG9kZXNrLCBJbmMxHzAdBgNVBAsMFkRlc2lnbiBTb2x1dGlvbnMgR3Jv
;;; dXAxFjAUBgNVBAMMDUF1dG9kZXNrLCBJbmMwggEiMA0GCSqGSIb3DQEBAQUAA4IB
;;; DwAwggEKAoIBAQDqmfToz8wEanfXT+H6tql3aUyaJRWCfFsYPFnGVXIl95fnZY3s
;;; OEfQvFkf9LVte5SwDWkjkReCGJlk4HaRYOTxkd7PkeAOOtYaUSBvULYRlKvAbe2n
;;; +VWwo4yrWATav8d7pKlbMP9f6pYxlaZQzsq/e+pLZwptP8C9Dfrm5OVgCIL/iPRN
;;; Iuvhl9YUZvnkZYmCnihdP4AS8g4d7rfjdxzT653433nO6tgs3fNgnkQQk6EdROwq
;;; esgQXRlH29yRND5xNfup9KiZ7L7Nm7AiM6laNwNIjBwbG4qMWuQ2Ml7hHzQpLaLF
;;; JRV33oHedeGSZ7OmA6+D5WoQtPpSt4YCcub5AgMBAAGjggFuMIIBajAJBgNVHRME
;;; AjAAMA4GA1UdDwEB/wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzBmBgNVHSAE
;;; XzBdMFsGC2CGSAGG+EUBBxcDMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5zeW1j
;;; Yi5jb20vY3BzMCUGCCsGAQUFBwICMBkaF2h0dHBzOi8vZC5zeW1jYi5jb20vcnBh
;;; MB8GA1UdIwQYMBaAFJY7U/B5M5evfYPvLivMyreGHnJmMCsGA1UdHwQkMCIwIKAe
;;; oByGGmh0dHA6Ly9zdi5zeW1jYi5jb20vc3YuY3JsMFcGCCsGAQUFBwEBBEswSTAf
;;; BggrBgEFBQcwAYYTaHR0cDovL3N2LnN5bWNkLmNvbTAmBggrBgEFBQcwAoYaaHR0
;;; cDovL3N2LnN5bWNiLmNvbS9zdi5jcnQwEQYJYIZIAYb4QgEBBAQDAgQQMBYGCisG
;;; AQQBgjcCARsECDAGAQEAAQH/MA0GCSqGSIb3DQEBCwUAA4IBAQAegWHWPJ8y1kt5
;;; 7JP8TOQlnYs0eMMg5/MHxlW3LhKv/PG8jZ2NDg8YrGuwBC7y3um+PA6KxRT9px8N
;;; KjniMX4NsPtQ81s2EITHy4uFfz6dTpgmL2BLE2/6FPmG4koEhY6zeT4tizeTscOR
;;; Mu1gCtr4Vq+BC/+0Ax6LKOGt5Ut1pJT89ivzZYZOIvEtt9AZRgh7GRg2Oz7X6MFn
;;; c3KudMQhCEnBEUkbS3fmC+kll5PuoF/R1XBcbby0ODfQ3xfwSpNd6WIMr2T5HnSC
;;; gOMmAsuP1Y6LjaCoYDP2mhiwMg797o0XVywnKLEeDGw/F9b/c+lpIBuWGWYnFjz7
;;; CTe7cgdcMYICIjCCAh4CAQEwgZMwfzELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5
;;; bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBOZXR3
;;; b3JrMTAwLgYDVQQDEydTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBDb2RlIFNpZ25p
;;; bmcgQ0ECEGS8scfO5NpYadWPHiL76fQwDQYJKoZIhvcNAQELBQAwDQYJKoZIhvcN
;;; AQEBBQAEggEAkCMdDS4/uaA9zkviGk1OUnzHI40HL/wIpFq/tNULNumE+bpT8lKF
;;; bq8678tFWh50fc87RSibuV+9GnzwIfAAj9BifJ4kkkysOAdXac494osT0fGFSyML
;;; lggvYBXZn1yaCvVm4+WKlhGZpn2xu6sBDh8I5Wak7MVVM5BFEDwkNqc/Y5eCWvvs
;;; 7mHVt7+XEOs1qOqzfx+lswzIZB23VBTMcHJCkWrjXfj/XH175e9Z7Zd7PmzlR1L+
;;; Mdr0tFv/TKHkrHKo3JCiqse2CMjsRAq/3kbCBU2YqN8WuAhzYqD1K5sjedQp1Qx5
;;; nuhZznOpkIyrJRmhG88Fxe67+BSg91J7laFhMF8GA1UdDjFYBFYzADkAOwAyAC8A
;;; NwAvADIAMAAxADYALwA1AC8AOQAvADMAMgAvAFQAaQBtAGUAIABmAHIAbwBtACAA
;;; dABoAGkAcwAgAGMAbwBtAHAAdQB0AGUAcgAAAA==
;;; -----END-SIGNATURE-----